/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;

public class sketch_sep04a
extends PApplet {
    final int NUM_EXPLOSIONS = 20;
    Explosion[] fireworks = new Explosion[20];

    public void setup() {
        this.size(800, 600, "processing.core.PGraphics3D");
        this.background(0);
        this.noStroke();
        int n = 0;
        while (n < 20) {
            this.fireworks[n] = new Explosion();
            ++n;
        }
    }

    public void draw() {
        this.background(0);
        int n = 0;
        while (n < 20) {
            Explosion explosion = this.fireworks[n];
            explosion.Draw();
            explosion.Grow();
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#F0F0F0", "sketch_sep04a"});
    }

    class Colour {
        public int r;
        public int g;
        public int b;
        public int a;

        public Colour() {
            this.r = (int)sketch_sep04a.this.random(32.0f, 255.0f);
            this.g = (int)sketch_sep04a.this.random(32.0f, 255.0f);
            this.b = (int)sketch_sep04a.this.random(32.0f, 255.0f);
            this.a = 255;
        }

        public Colour(int n, int n2, int n3, int n4) {
            this.r = n;
            this.g = n2;
            this.b = n3;
            this.a = n4;
        }

        public Colour GetDarkened(int n) {
            int n2 = sketch_sep04a.max(0, this.r - n);
            int n3 = sketch_sep04a.max(0, this.g - n);
            int n4 = sketch_sep04a.max(0, this.b - n);
            int n5 = sketch_sep04a.max(0, this.a - n);
            return new Colour(n2, n3, n4, n5);
        }
    }

    class Coord {
        private final float MAX_Z = 100.0f;
        public float x;
        public float y;
        public float z;

        public Coord() {
            this.x = sketch_sep04a.this.random(0.0f, sketch_sep04a.this.width);
            this.y = sketch_sep04a.this.random(0.0f, sketch_sep04a.this.height);
            this.z = sketch_sep04a.this.random(0.0f, 100.0f);
        }

        public Coord(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }

    class Explosion {
        private ArrayList<FCircle> myCircles = new ArrayList();
        private final float MAX_OFFSET = 5.0f;
        private final int MAX_PARTICLES = 100;
        private boolean growing = true;

        public Explosion() {
            this.myCircles.add(new FCircle());
        }

        public void Draw() {
            int n = 0;
            while (n < this.myCircles.size()) {
                FCircle fCircle = this.myCircles.get(n);
                fCircle.Draw();
                if (n != 0) {
                    fCircle.Move();
                }
                ++n;
            }
        }

        public void Grow() {
            if (!this.growing) {
                this.Shrink();
            } else {
                FCircle fCircle = this.myCircles.get(this.myCircles.size() - 1);
                Vertex vertex = fCircle.GetVertex();
                Vertex vertex2 = new Vertex(vertex.x + sketch_sep04a.this.random(-5.0f, 5.0f), vertex.y + sketch_sep04a.this.random(-5.0f, 5.0f), vertex.z + sketch_sep04a.this.random(-5.0f, 5.0f));
                this.myCircles.add(new FCircle(vertex2, fCircle.GetColor(), fCircle.GetFrame()));
            }
            if (this.myCircles.size() > 100) {
                this.growing = false;
            }
        }

        private void Shrink() {
            this.myCircles.remove(1);
            if (this.myCircles.size() < 2) {
                this.growing = true;
            }
        }
    }

    class FCircle {
        private float numRings = 50.0f;
        private final float RING_INCREASE_AMOUT = 0.1f;
        private Vertex myPoint;
        private Colour myColor;
        private final int MAX_RADIUS = 20;
        private PGraphics myFrame = null;

        public FCircle() {
            this.myPoint = new Vertex();
            this.myColor = new Colour();
        }

        public FCircle(Vertex vertex, Colour colour) {
            this.myColor = colour;
            this.myPoint = vertex;
        }

        public FCircle(Vertex vertex, Colour colour, PGraphics pGraphics) {
            this.myColor = colour;
            this.myPoint = vertex;
            this.myFrame = pGraphics;
        }

        public void Draw() {
            if (this.myFrame == null) {
                this.Render();
            }
            sketch_sep04a.this.blend(this.myFrame, 0, 0, sketch_sep04a.this.width, sketch_sep04a.this.height, (int)this.myPoint.x, (int)this.myPoint.y, 20, 20, 2);
        }

        private void Render() {
            PGraphics pGraphics = sketch_sep04a.this.createGraphics(80, 80, "processing.core.PGraphics3D");
            pGraphics.beginDraw();
            pGraphics.background(0.0f, 0.0f, 0.0f, 0.0f);
            pGraphics.noStroke();
            int n = this.GetStep();
            int n2 = (int)this.numRings;
            while (n2 > 0) {
                int n3 = PApplet.parseInt((float)(n2 * n * 20) / this.numRings);
                Colour colour = this.myColor.GetDarkened(n2 * n);
                pGraphics.fill(colour.r, colour.g, colour.b, colour.a);
                pGraphics.ellipse(40.0f, 40.0f, n3, n3);
                --n2;
            }
            pGraphics.endDraw();
            this.myFrame = pGraphics;
        }

        public PGraphics GetFrame() {
            return this.myFrame;
        }

        public void Move() {
            this.myPoint.Move();
        }

        public Vertex GetVertex() {
            return this.myPoint;
        }

        public Colour GetColor() {
            return this.myColor;
        }

        private int GetStep() {
            return (int)(256.0f / this.numRings);
        }
    }

    class Vector
    extends Coord {
        public Vector() {
        }

        public Vector(float f, float f2, float f3) {
            super(f, f2, f3);
        }
    }

    class Vertex
    extends Coord {
        private Vector myVector;

        public Vertex() {
            this.InitVector();
        }

        public Vertex(float f, float f2, float f3) {
            super(f, f2, f3);
            this.InitVector();
        }

        private void InitVector() {
            float f = sketch_sep04a.this.random(-3.0f, 3.0f);
            float f2 = sketch_sep04a.this.random(-3.0f, 3.0f);
            float f3 = sketch_sep04a.this.random(-3.0f, 3.0f);
            this.myVector = new Vector(f, f2, f3);
        }

        public void Move() {
            this.x += this.myVector.x;
            this.y += this.myVector.y;
            this.z += this.myVector.z;
        }
    }
}

