/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;

public class sketch_sep08a
extends PApplet {
    ArrayList<Vertex> splinePoints = new ArrayList();
    PGraphics lastFrame;
    final int RING_SIZE = 3;
    final int MAX_VERTICES = 500;
    final float feedbackOffset = 1.0f;
    boolean growing = true;
    final float ANGLE_CHANGE = 0.001f;
    final float MIN_ANGLE = 0.0f;
    final float MAX_ANGLE = (float)Math.PI * 2;
    float myAngle = 0.0f;
    boolean spinClockwise = true;
    final float SCALE_CHANGE = 0.0f;
    final float MIN_SCALE = 1.2f;
    final float MAX_SCALE = 3.0f;
    float myScale = 1.2f;
    boolean zooming = true;

    public void setup() {
        this.size(640, 480, "processing.core.PGraphics3D");
        this.smooth();
        this.stroke(255.0f, 0.0f, 0.0f);
        this.noFill();
    }

    public void draw() {
        this.background(0);
        this.RotateAndScale();
        if (this.lastFrame != null) {
            this.image(this.lastFrame, 0.0f, 0.0f, this.width, this.height);
        }
        this.RenderRings();
        if (this.splinePoints.size() > 500) {
            this.growing = false;
        }
        if (this.splinePoints.size() < 1) {
            this.growing = true;
        }
        if (this.growing) {
            this.AddVertex();
        } else {
            this.splinePoints.remove(0);
        }
        this.lastFrame = this.Feedback(this.g);
    }

    public void RotateAndScale() {
        this.translate(this.width / 2, this.height / 2);
        this.scale(this.myScale);
        if (this.myScale > 3.0f) {
            this.zooming = false;
        }
        if (this.myScale < 1.2f) {
            this.zooming = true;
        }
        if (this.zooming) {
            this.myScale += 0.0f;
        }
        this.rotateZ(this.myAngle);
        if (this.myAngle > (float)Math.PI * 2) {
            this.spinClockwise = false;
        }
        if (this.myAngle < 0.0f) {
            this.spinClockwise = true;
        }
        this.myAngle = this.spinClockwise ? (this.myAngle += 0.001f) : (this.myAngle -= 0.001f);
        this.translate(-this.width / 2, -this.height / 2);
    }

    public void RenderSpline() {
        if (this.splinePoints.size() < 1) {
            return;
        }
        Vertex vertex = this.splinePoints.get(0);
        Vertex vertex2 = this.splinePoints.get(this.splinePoints.size() - 1);
        this.beginShape();
        this.curveVertex(vertex.x, vertex.y, vertex.z);
        int n = 0;
        while (n < this.splinePoints.size()) {
            Vertex vertex3 = this.splinePoints.get(n);
            this.curveVertex(vertex3.x, vertex3.y, vertex3.z);
            vertex3.Move();
            ++n;
        }
        this.curveVertex(vertex2.x, vertex2.y, vertex2.z);
        this.endShape();
    }

    public void RenderRings() {
        int n = 0;
        while (n < this.splinePoints.size()) {
            Vertex vertex = this.splinePoints.get(n);
            this.translate(vertex.x, vertex.y, vertex.z);
            float f = 3.0f + vertex.z / 10.0f;
            this.ellipse(0.0f, 0.0f, f, f);
            this.translate(-vertex.x, -vertex.y, -vertex.z);
            vertex.Move();
            ++n;
        }
    }

    public PGraphics Feedback(PGraphics pGraphics) {
        int n;
        PGraphics pGraphics2 = this.createGraphics(pGraphics.width, pGraphics.height, "processing.core.PGraphics3D");
        pGraphics.loadPixels();
        pGraphics2.loadPixels();
        int n2 = n = 1;
        while (n2 < pGraphics.width * pGraphics.height) {
            float f = this.red(pGraphics.pixels[n2 - n]);
            if (f > 0.0f) {
                pGraphics2.pixels[n2] = this.color(f, 0.0f, 0.0f);
            }
            ++n2;
        }
        pGraphics2.updatePixels();
        return pGraphics2;
    }

    public void AddVertex() {
        float f = this.random(0.0f, this.width);
        float f2 = this.random(0.0f, this.height);
        float f3 = this.random(0.0f, 100.0f);
        Vertex vertex = new Vertex(f, f2, f3);
        vertex.RandomizeVector(0.5f);
        this.splinePoints.add(vertex);
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#F0F0F0", "sketch_sep08a"});
    }

    class Coord {
        public float x;
        public float y;
        public float z;

        public Coord() {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }

        public Coord(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
        }
    }

    class Vector
    extends Coord {
        public Vector() {
        }

        public Vector(float f, float f2, float f3) {
            super(f, f2, f3);
        }
    }

    class Vertex
    extends Coord {
        private Vector myVector;

        public Vertex() {
            this.myVector = new Vector();
        }

        public Vertex(float f, float f2, float f3) {
            super(f, f2, f3);
            this.myVector = new Vector();
        }

        public void Move() {
            this.x += this.myVector.x;
            this.y += this.myVector.y;
            this.z += this.myVector.z;
        }

        public void RandomizeVector(float f) {
            this.myVector.x = sketch_sep08a.this.random(-f, f);
            this.myVector.y = sketch_sep08a.this.random(-f, f);
            this.myVector.z = sketch_sep08a.this.random(-f, f);
        }
    }
}

