/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PVector;

public class Spiromatic
extends PApplet {
    float angle = 0.0f;
    float ANGLE_CHANGE = 0.05f;
    final float MIN_DISTANCE = 5.0f;
    ArrayList<Line> myLines = new ArrayList();

    public void setup() {
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Spiromatic.this.mouseWheel(mouseWheelEvent.getWheelRotation());
            }
        });
        this.size(800, 600, "processing.core.PGraphics3D");
        this.smooth();
        this.noFill();
        this.stroke(255);
        this.myLines.add(new Line());
    }

    public void mouseWheel(int n) {
        this.ANGLE_CHANGE = n < 0 ? (this.ANGLE_CHANGE -= 0.01f) : (this.ANGLE_CHANGE += 0.01f);
    }

    public void draw() {
        this.background(0);
        this.translate(this.width / 2, this.height / 2);
        this.rotateZ(this.angle);
        this.angle += this.ANGLE_CHANGE;
        if (this.angle >= (float)Math.PI * 2) {
            this.angle = 0.0f;
        }
        int n = 0;
        while (n < this.myLines.size()) {
            Line line = this.myLines.get(n);
            line.Draw();
            ++n;
        }
        if (this.mousePressed) {
            this.translate(-this.width / 2, -this.height / 2);
            PVector pVector = new PVector(this.mouseX - this.width / 2, this.mouseY - this.height / 2);
            float f = pVector.mag();
            PVector pVector2 = new PVector(f * Spiromatic.cos(this.angle), f * Spiromatic.sin(this.angle));
            this.myLines.get(this.myLines.size() - 1).AddPoint(pVector2);
        }
    }

    public void mouseReleased() {
        this.myLines.add(new Line());
    }

    public void keyPressed() {
        if (this.keyCode == 10) {
            this.myLines.clear();
            this.myLines.add(new Line());
        }
    }

    public void Rotate(boolean bl) {
        int n = bl ? 1 : -1;
        this.rotateZ((float)n * this.angle);
        this.angle += this.ANGLE_CHANGE;
        if (this.angle >= (float)Math.PI * 2) {
            this.angle = 0.0f;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#F0F0F0", "Spiromatic"});
    }

    class Line {
        private ArrayList<PVector> myPoints = new ArrayList();
        private float r;
        private float g;
        private float b;

        public Line() {
            this.r = Spiromatic.this.random(32.0f, 255.0f);
            this.g = Spiromatic.this.random(32.0f, 255.0f);
            this.b = Spiromatic.this.random(32.0f, 255.0f);
        }

        public void RotatePoints(float f) {
            PVector pVector = new PVector(Spiromatic.cos(f), Spiromatic.sin(f));
            int n = 0;
            while (n < this.myPoints.size()) {
                PVector pVector2 = this.myPoints.get(n);
                pVector2.add(pVector);
                ++n;
            }
        }

        public void Draw() {
            if (this.myPoints.size() < 1) {
                return;
            }
            PVector pVector = this.myPoints.get(0);
            PVector pVector2 = this.myPoints.get(this.myPoints.size() - 1);
            Spiromatic.this.beginShape();
            Spiromatic.this.curveVertex(pVector.x, pVector.y);
            int n = 0;
            while (n < this.myPoints.size()) {
                if (n < 256) {
                    Spiromatic.this.stroke(Spiromatic.min((float)(n + 32), this.r), Spiromatic.min((float)(n + 32), this.g), Spiromatic.min((float)(n + 32), this.b));
                } else {
                    Spiromatic.this.stroke(this.r, this.g, this.b);
                }
                PVector pVector3 = this.myPoints.get(n);
                Spiromatic.this.curveVertex(pVector3.x, pVector3.y);
                ++n;
            }
            Spiromatic.this.curveVertex(pVector2.x, pVector2.y);
            Spiromatic.this.endShape();
        }

        public void AddPoint(PVector pVector) {
            if (this.myPoints.size() < 1 || pVector.dist(this.myPoints.get(this.myPoints.size() - 1)) > 5.0f) {
                this.myPoints.add(pVector);
            }
        }
    }
}

